﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class MenuShowDelay : UserControl,IControl,ICorrespondenceOS
    {
        private MenuShowDelayController menuShowDelayController;

        public MenuShowDelay()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,  
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetMenuShowDelayValue(int i)
        {
            textBox1.Text = i.ToString();
        }


        public int GetMenuShowDelayValue()
        {
            return Convert.ToInt32(textBox1.Text);
        }

        #region IControl メンバ

        public void Apply()
        {
            menuShowDelayController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return menuShowDelayController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void MenuShowDelay_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            menuShowDelayController = new MenuShowDelayController(this,
                                                                        (IMenuShowDelayStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new MenuShowDelayDefaultStrategy()
                                                                                 }));
            menuShowDelayController.Read();
        }
    }
}
